import os
import json

def postprocess_json_files(input_dir, output_dir):
    os.makedirs(output_dir, exist_ok=True)

    for filename in os.listdir(input_dir):
        if filename.endswith(".json"):
            input_path = os.path.join(input_dir, filename)
            output_path = os.path.join(output_dir, filename)

            with open(input_path, "r", encoding="utf-8") as f:
                data = json.load(f)

            for item in data:
                for prompt, content in item.items():
                    response_text = content.get("Response", "").lower()
                    if "no response" in response_text:
                        if "no response" in response_text or "no response." in response_text:
                            content["atomic_units"] = []
                            content["hallucinated_atomic_units"] = []
                            content["scores"]["hallucination_score"] = 0.0
                            content["scores"]["response_ratio"] = 0.0

            with open(output_path, "w", encoding="utf-8") as f:
                json.dump(data, f, indent=2, ensure_ascii=False)

input_directory = "fp-final"
output_directory = "fp-final-org"
postprocess_json_files(input_directory, output_directory)
